// keepromDoc.cpp : implementation of the CkeepromDoc class
//

#include "stdafx.h"
#include <conio.h>
#include "keeprom.h"

#include "keepromDoc.h"
#include "keepromModify.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SDA	0x378	//x--- ---- pin 9 (_output)
#define SCL 0x37a	//---- -x-- pin 16 (_output)
#define ACK 0x379	//-x-- ---- pin 10 (input) pin 2 and pin 10 connected by a diode 

/////////////////////////////////////////////////////////////////////////////
// CkeepromDoc

IMPLEMENT_DYNCREATE(CkeepromDoc, CDocument)

BEGIN_MESSAGE_MAP(CkeepromDoc, CDocument)
	//{{AFX_MSG_MAP(CkeepromDoc)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
    ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
    ON_COMMAND(ID_TOOL_VERIFY, OnVerify)
    ON_COMMAND(ID_TOOL_UPLOAD, OnUpload)
    ON_COMMAND(ID_TOOL_DOWNLOAD, OnDownload)
    ON_COMMAND(ID_TOOL_MODIFY, OnModifyDlg)
    ON_COMMAND(ID_TOOL_SETTODEFAULTS, OnSetToDefaults)
   	
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CkeepromDoc construction/destruction

CkeepromDoc::CkeepromDoc()
{
	// TODO: add one-time construction code here

}

CkeepromDoc::~CkeepromDoc()
{
}

BOOL CkeepromDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

void CkeepromDoc::delay()
{
    int a;

	for (a=0; a<100; a++);
}


void CkeepromDoc::OnFileSave()
{
	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();

    if ( !pApp->csFilename.IsEmpty () )
        FileSave ( pApp->csFilename );
    else
        OnFileSaveAs ();

    return;    
}


void CkeepromDoc::OnFileSaveAs()
{
	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();

    TCHAR szFileters[] = 
            _T ("Data files (*.dat)|*.dat|All files (*.*)|*.*||");

    CFileDialog dlg ( TRUE, _T("dat"), _T("*.dat"), OFN_HIDEREADONLY, szFileters );

    if (dlg.DoModal () == IDOK)
    {
        
        if ( FileSave ( dlg.GetPathName () ))
            pApp->csFilename = dlg.GetPathName ();

        SetTitle ( pApp->csFilename );

    }

    return;    

}

BOOL CkeepromDoc::FileSave ( LPCTSTR pszFile )
{
    CFile cfFile;
    BOOL bResult = FALSE;
    CFileException cfeErr;

	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();

    if ( cfFile.Open ( pszFile, CFile::modeWrite | CFile::modeCreate, &cfeErr ))
    {
        //
        // There is no error checking, wish the best!!!
        //
        cfFile.Write ( pApp->gold_data, EEPROMSIZE ); 
 
        cfFile.Close ();

        bResult = TRUE;
    }
    else
    {
        cfeErr.ReportError ();
 
    }

    return bResult;
}

void CkeepromDoc::OnFileNew()
{
    int i;
	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();

//    CWinApp::OnFileNew();

    for ( i = 0; i < EEPROMSIZE ; i++ )
    {
        pApp->gold_data [ i ] = 0x00;
    }

   	pApp->m_pMainWnd->Invalidate();

    pApp->m_pMainWnd->UpdateWindow();

   
    return;   
}

void CkeepromDoc::OnFileOpen()
{
    //CWinApp::OnFileOpen();
    CFile cfFile;
    CFileException cfeErr;
	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();


    TCHAR szFileters[] = 
        _T ("Data files (*.dat)|*.dat|All files (*.*)|*.*||");

    CFileDialog dlg (TRUE, _T("dat"), _T("*.dat"),
        OFN_FILEMUSTEXIST | OFN_HIDEREADONLY, szFileters );

    if (dlg.DoModal () == IDOK)
    {
        pApp->csFilename = dlg.GetPathName ();

        if ( cfFile.Open ( pApp->csFilename, CFile::modeRead, &cfeErr ))
        {
            cfFile.Read ( pApp->gold_data, EEPROMSIZE );

           	pApp->m_pMainWnd->Invalidate();

            pApp->m_pMainWnd->UpdateWindow();

            SetTitle ( pApp->csFilename );

            cfFile.Close ();
        }
        else
        {
            cfeErr.ReportError ();
        }
    }

    return;    
}


void CkeepromDoc::OnVerify()
{
    verify_eeprom();
}

void CkeepromDoc::OnUpload()
{
	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();

	read_eeprom();

    //CkeepromApp::;

    //UpdateWindow(GetMainWnd());

    //gold_data[0] = 255;

   	pApp->m_pMainWnd->Invalidate();

    pApp->m_pMainWnd->UpdateWindow();

    SetTitle ( _T("Upload") );

   
}

void CkeepromDoc::OnDownload()
{
	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();

	CString	csTitle;
    char sErrMsg[100];

    sprintf ( sErrMsg, "Download is completed, please reset the switch for the new settings to take effect.");
	csTitle.LoadString(IDS_TITLE);        

    write_eeprom();

    MessageBox( pApp->m_pMainWnd->GetSafeHwnd(), sErrMsg, csTitle, MB_OK | MB_ICONINFORMATION );
}

void CkeepromDoc::OnModifyDlg()
{
	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();

	CModifyDlg modifyDlg;

	if ( modifyDlg.DoModal() == IDOK )
    {
   	    pApp->m_pMainWnd->Invalidate();

        pApp->m_pMainWnd->UpdateWindow();
    }
}

void CkeepromDoc::OnSetToDefaults()
{
    CFile cfFile;
    CFileException cfeErr;

	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();

    pApp->csFilename = _T("default.dat");

    if ( cfFile.Open ( pApp->csFilename, CFile::modeRead, &cfeErr ))
    {
        // no error checking here
        cfFile.Read ( pApp->gold_data, EEPROMSIZE );

        pApp->m_pMainWnd->Invalidate();

        pApp->m_pMainWnd->UpdateWindow();
	    
        write_eeprom();

        SetTitle ( pApp->csFilename );
        
        cfFile.Close ();
    }
    else
    {
        cfeErr.ReportError ();
    }

}


/////////////////////////////////////////////////////////////////////////////
// CkeepromDoc serialization

void CkeepromDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}


/////////////////////////////////////////////////////////////////////////////
// CErrorDlg dialog used for App About

class CErrorDlg : public CDialog
{
public:
	CErrorDlg();

// Dialog Data
	//{{AFX_DATA(CErrorDlg)
	enum { IDD = IDD_ERRORLIST };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CErrorDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CErrorDlg)
    //virtual BOOL OnInitDialog();
    afx_msg void OnPaint();
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CErrorDlg::CErrorDlg() : CDialog(CErrorDlg::IDD)
{
	//{{AFX_DATA_INIT(CErrorDlg)
	//}}AFX_DATA_INIT
}

void CErrorDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CErrorDlg)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CErrorDlg, CDialog)
	//{{AFX_MSG_MAP(CErrorDlg)
    ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//BOOL CErrorDlg::OnInitDialog() 
void CErrorDlg::OnPaint() 
{
    int i;
    WORD wError = 0;
    CDC * pDC;
	COLORREF cBKColor;

	char cString[50];
	CFont font;
	CFont * def_font;

	LOGFONT lf;

	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();

    memset(&lf, 0, sizeof(LOGFONT));

	lf.lfHeight = 16;

	strcpy(lf.lfFaceName, "Arial");

	//strcpy(lf.lfFaceName, "Times New Roman");

	font.CreateFontIndirect (&lf);

    pDC = GetDC() ;

	cBKColor = pDC->GetBkColor ();

	def_font = pDC->SelectObject (&font);

	cBKColor = GetSysColor ( COLOR_BTNFACE  );

	pDC->SetBkColor ( cBKColor );

	for (i=0; i<128;i++)
	{
		if (pApp->gold_data[i] != pApp->compare[i])
		{ 
            //
            // We only disply the first 60 bytes
            //
	        if ( wError < 60 )
            {
			    sprintf ( cString, "%02d", i);
			    pDC->TextOut ( 40 + 205 * (wError / 20), 55 + (wError % 20) * 15, cString, strlen ( cString ) );

                sprintf ( cString, "%02X", pApp->gold_data [i]);
			    pDC->TextOut ( 105 + 205 * (wError / 20), 55 + (wError % 20) * 15, cString, strlen ( cString ) );

                sprintf ( cString, "%02X", pApp->compare [i]);
			    pDC->TextOut ( 165 + 205 * (wError / 20), 55 + (wError % 20) * 15, cString, strlen ( cString ) );
            }
            wError++;

		}

	}	

    if ( !wError ) // No error found
    {
        sprintf ( cString, "%s", "PASS!");
		pDC->TextOut ( 80, 100, cString, strlen ( cString ) );
		pDC->TextOut ( 285, 100, cString, strlen ( cString ) );
 		pDC->TextOut ( 490, 100, cString, strlen ( cString ) );
    }

    //MessageBox( m_pMainWnd->GetSafeHwnd(), sErrMsg, csTitle, MB_OK | MB_ICONSTOP );

	pDC->SelectObject (&def_font);

	font.DeleteObject();

	ReleaseDC ( pDC );

    CDialog::OnPaint();

//	CDialog::OnInitDialog();

//	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}

void CkeepromDoc::SlaveMode()
{
	    _outp(SDA, 0x80);delay();		//write control byte '1011 1111'
	    _outp(SCL, 0x04);delay();		//'1'
	    _outp(SCL, 0x00);delay();	
	    
	    _outp(SDA, 0x00);delay();		//'0'
	    _outp(SCL, 0x04);delay();
	    _outp(SCL, 0x00);delay();	

	    _outp(SDA, 0x80);delay();		//'1'
	    _outp(SCL, 0x04);delay();
	    _outp(SCL, 0x00);delay();	

	    _outp(SDA, 0x80);delay();		//'1'
	    _outp(SCL, 0x04);delay();
	    _outp(SCL, 0x00);delay();	

	    _outp(SDA, 0x80);delay();		//'1'
	    _outp(SCL, 0x04);delay();
	    _outp(SCL, 0x00);delay();
	    
	    _outp(SDA, 0x80);delay();		//'1'
	    _outp(SCL, 0x04);delay();
	    _outp(SCL, 0x00);delay();
	    
	    _outp(SDA, 0x80);delay();		//'1'
	    _outp(SCL, 0x04);delay();
	    _outp(SCL, 0x00);delay();

        return;
}

void CkeepromDoc::MasterMode()
{

	_outp(SDA, 0x80);delay();		//write control byte '1010 000 0'
	_outp(SCL, 0x04);delay();		//'1'
	_outp(SCL, 0x00);delay();	
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x80);delay();		//'1'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	
	_outp(SDA, 0x00);delay();		//'0'
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

    return;
}

void CkeepromDoc::read_eeprom()
{
	unsigned char indata=0;	//input data buffer
	unsigned char data=0;
    int address;

	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//start condition        
	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x00);delay();

    if ( pApp->m_bSFlag )
    {
        SlaveMode();
    }
    else
    {
        MasterMode();
    }

	_outp(SDA, 0x00);delay();		//'0' write condition
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();		
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	


	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	


	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
	

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	
	_outp(SCL, 0x04);delay();

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//start condition        
	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x00);delay();

    if ( pApp->m_bSFlag )
    {
        SlaveMode();    
    }
    else
    {
        MasterMode();
    }

	_outp(SDA, 0x80);delay();		//'1' read condition
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	

	//for ( address=0; address<129; address++)
	for ( address=0; address<128; address++)
	{
        _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);

	    indata<<=1;	
	    indata >>= 7;			// clear up unwanted bits
	    indata <<=7;
	    data=0x00;
	    data = data | indata;

   
	    _outp(SCL, 0x00);delay();
        _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=6;
	    data = data | indata;	


	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();	//read data
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=5;
	    data = data | indata;	

	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();		//read data
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=4;
	    data=data | indata;
	    
	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();		//read data
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=3;
	    data=data | indata;

	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();		//read data
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=2;
	    data=data | indata;

	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();		//read data
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=1;
	    data=data | indata;

	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();		//read data

	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    data=data | indata;	

	    _outp(SCL, 0x00);delay();
	    _outp(SDA, 0x00);delay();
	    _outp(SCL, 0x00);delay();		//acknowledge from CPU
	    _outp(SCL, 0x04);delay();
	    _outp(SCL, 0x00);delay();
	    _outp(SDA, 0x80);delay();

	    pApp->gold_data[address]=data;

	}

	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x04);delay();		//stop condition, end of sequential read
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x00);delay();
	_outp(SDA, 0x00);delay();
/*
	printf(" #  data #  data #  data #  data #  data #  data #  data #  data #  data #  data\n");
	for (i=0; i<128;i++)
		{

		printf("%3d %3x ", i,gold_data[i]);

		}	
*/
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();
}


void CkeepromDoc::write_eeprom()
{
    int address;
    unsigned char verify;
    int a;

	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();

	for ( address=0; address<128; address++)
	{
initial:		
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();	//start condition        
   	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x00);delay();

    if ( pApp->m_bSFlag )
    {
        SlaveMode();    
    }
    else
    {
        MasterMode();
    }


	_outp(SDA, 0x00);delay();		//'0' write condition
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();
	
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//acknowledge

	verify = _inp(ACK);				//verify acknowledge
	verify = verify & 0x40;
	if (verify != 0x00)
	{
	
		goto initial;
	}
	else
	_outp(SCL, 0x00);delay();	


	 unsigned char addr=address;
	_outp(SDA, addr);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();		
	//printf("%d  ", address);
	addr <<=1;
	_outp(SDA, addr);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	addr <<=1;
	_outp(SDA, addr);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	addr <<=1;
	_outp(SDA, addr);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	addr <<=1;
	_outp(SDA, addr);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	addr <<=1;
	_outp(SDA, addr);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	addr <<=1;
	_outp(SDA, addr);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	addr <<=1;
	_outp(SDA, addr);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	


	unsigned char data= pApp->gold_data[address];
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();		

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
	
	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	data<<=1;	
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	data<<=1;	 
	_outp(SDA, data);delay();		//write data
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x04);delay();		//stop condition, end data write
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x00);delay();
	_outp(SDA, 0x00);delay();


	for (a=0; a<10000; a++);
	{}
	

	}
		
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();
}


void CkeepromDoc::verify_eeprom()

{

    CErrorDlg errorDlg;

	CkeepromApp	*pApp;
	pApp = (CkeepromApp *)AfxGetApp();


//    int i;
    //unsigned char compare[128];	

	unsigned char indata=0;	//input data buffer
	unsigned char data=0;

//	errorDlg.DoModal();

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//start condition        
	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x00);delay();


    if ( pApp->m_bSFlag )
    {
        SlaveMode();    
    }
    else
    {
        MasterMode();
    }

	_outp(SDA, 0x00);delay();		//'0' write condition
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();		
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	

	_outp(SDA, 0x00);delay();		//write address
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();	
		
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	
	_outp(SCL, 0x04);delay();

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//start condition        
	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x00);delay();

    if ( pApp->m_bSFlag )
    {
        SlaveMode();    
    }
    else
    {
        MasterMode();
    }

	_outp(SDA, 0x80);delay();		//'1' read condition
	_outp(SCL, 0x04);delay();
	_outp(SCL, 0x00);delay();

	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();		//acknowledge
	_outp(SCL, 0x00);delay();	

	//for ( unsigned char x=0; x<129; x++)
    for ( unsigned char x=0; x<128; x++)
	{
        _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);

	    indata<<=1;	
	    indata >>= 7;			// clear up unwanted bits
	    indata <<=7;
	    data=0x00;
	    data = data | indata;

   
	    _outp(SCL, 0x00);delay();
        _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=6;
	    data = data | indata;	


	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();	//read data
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=5;
	    data = data | indata;	

	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();		//read data
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=4;
	    data=data | indata;
	    
	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();		//read data
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=3;
	    data=data | indata;

	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();		//read data
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=2;
	    data=data | indata;

	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();		//read data
	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    indata <<=1;
	    data=data | indata;

	    _outp(SCL, 0x00);delay();
	    _outp(SCL, 0x04);delay();
	    indata=_inp(ACK);delay();		//read data

	    indata <<=1;			//clear up unwanted bits
	    indata >>=7;
	    data=data | indata;	

	    _outp(SCL, 0x00);delay();
	    _outp(SDA, 0x00);delay();
	    _outp(SCL, 0x00);delay();		//acknowledge from CPU
	    _outp(SCL, 0x04);delay();
	    _outp(SCL, 0x00);delay();
	    _outp(SDA, 0x80);delay();

	    pApp->compare[x]=data;

	}

	_outp(SDA, 0x00);delay();
	_outp(SCL, 0x04);delay();		//stop condition, end of sequential read
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x00);delay();
	_outp(SDA, 0x00);delay();
	//printf("");

/*
	for (i=0; i<128;i++)
	{

		if (pApp->gold_data[i] != pApp->compare[i])
		{ 
	

//				printf(" ERROR: ADDRESS   WRITE DATA   READ DATA\n");
//				printf("          %d         %x            %x   \n", i, gold_data[i], compare[i]);
//      sprintf ( sTemp, "          %d                   %x            %x   \n", i+1, gold_data[i], compare[i] );
                //strcat ( sErrMsg, sTemp );
				//break;
			}
//		else
//			printf("Verify O.K.\n");
	}	
*/
	_outp(SDA, 0x80);delay();
	_outp(SCL, 0x04);delay();

    //MessageBox( m_pMainWnd->GetSafeHwnd(), sErrMsg, csTitle, MB_OK | MB_ICONSTOP );

	errorDlg.DoModal();

}




/////////////////////////////////////////////////////////////////////////////
// CkeepromDoc diagnostics

#ifdef _DEBUG
void CkeepromDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CkeepromDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CkeepromDoc commands
